/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.asistentes;

import ec.gob.sri.dimm.api.logger.PluginLogger;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.ui.asistentes.AsistenteBase;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.ValidarAnexoPaginaBusqueda;
import ec.gob.sri.dimm.ats.ui.operaciones.OperacionValidacionAnexo;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbenchWizard;

public class AsistenteValidarATS
extends AsistenteBase
implements IWorkbenchWizard {
    public static final String ID = "ec.gob.sri.dimm.ats.ui.asistentes.AsistenteValidarATS";
    private ValidarAnexoPaginaBusqueda paginaBusqueda;
    private ResultadoValidacion resultadoValidacion = null;
    private File archivoErroresInformacion = null;
    private File archivoAnexo = null;
    private Boolean tieneErrores = Boolean.FALSE;
    private Boolean tieneWarnings = Boolean.FALSE;

    public AsistenteValidarATS() {
        this.setNeedsProgressMonitor(true);
    }

    public ResultadoValidacion getResultadoValidacion() {
        return this.resultadoValidacion;
    }

    public File getArchivoErroresInformacion() {
        return this.archivoErroresInformacion;
    }

    public File getArchivoAnexo() {
        return this.archivoAnexo;
    }

    public void addPages() {
        this.paginaBusqueda = new ValidarAnexoPaginaBusqueda();
        this.addPage((IWizardPage)this.paginaBusqueda);
    }

    public boolean performFinish() {
        File archivoXML = this.paginaBusqueda.getArchivoXML();
        OperacionValidacionAnexo operacionValidacion = new OperacionValidacionAnexo(archivoXML);
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)operacionValidacion);
        }
        catch (InvocationTargetException e) {
            PluginLogger.logError((String)"Error validando anexo externo.", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e);
            Throwable cause = e.getCause();
            if (cause == null) {
                this.mostrarError("Se ha producido un error inesperado al convertir el anexo.");
            } else if (cause instanceof OutOfMemoryError) {
                this.mostrarError("Estimado Contribuyente, para convertir archivos superiores a 15MB seguir la gu\u00eda del manual de usuario.");
            } else if (cause instanceof NullPointerException) {
                this.mostrarError("Estimado Contribuyente, el archivo no cumple con las especificaciones t\u00e9cnicas establecidas para el anexo ");
            } else if (cause instanceof IOException) {
                this.mostrarError("Estimado Contribuyente, no hay espacio en disco suficiente o no existen permisos para crear el archivo XML");
            } else {
                this.mostrarError("Estimado Contribuyente, el archivo no cumple con las especificaciones t\u00e9cnicas establecidas para el anexo ");
            }
            return false;
        }
        catch (InterruptedException e) {
            PluginLogger.logError((String)"Se ha interrumpido el proceso de validaci\u00f3n", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e);
            this.mostrarError("Se ha interrumpido el proceso de validaci\u00f3n. Consulte el archivo de errores");
            return false;
        }
        this.archivoErroresInformacion = operacionValidacion.getArchivoErroresInformacion();
        this.resultadoValidacion = operacionValidacion.getResultadoValidacionEsquema();
        this.archivoAnexo = archivoXML;
        this.tieneErrores = operacionValidacion.isTieneErrores();
        this.tieneWarnings = operacionValidacion.isTieneWarnings();
        if (this.tieneErrores.booleanValue()) {
            this.mostrarError(String.format("Se han producido errores al validar el anexo que est\u00e1 siendo importado.%n%nRevise los detalles de errores para obtener m\u00e1s informaci\u00f3n.", new Object[0]));
        }
        return true;
    }

    public Boolean isTieneErrores() {
        return this.tieneErrores;
    }

    public void setTieneErrores(Boolean tieneErrores) {
        this.tieneErrores = tieneErrores;
    }

    public Boolean isTieneWarnings() {
        return this.tieneWarnings;
    }

    public void setTieneWarnings(Boolean tieneWarnings) {
        this.tieneWarnings = tieneWarnings;
    }
}

